/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer.navigator.resources;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.resources.ResourceDropAdapterAssistant;

public class AppExplorerDropAdapterAssistant
extends ResourceDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (aTarget == null || aDropTargetEvent.data == null) {
            return Status.CANCEL_STATUS;
        }
        TransferData currentTransfer = aDropAdapter.getCurrentTransfer();
        if (FileTransfer.getInstance().isSupportedType(currentTransfer) && aDropAdapter.getCurrentTarget() == null && aTarget instanceof IProject) {
            return this.performFileDrop(aDropAdapter, aDropTargetEvent.data, (IProject)aTarget);
        }
        return super.handleDrop(aDropAdapter, aDropTargetEvent, aTarget);
    }

    private IStatus performFileDrop(CommonDropAdapter anAdapter, Object data, final IProject target) {
        MultiStatus problems = new MultiStatus("com.aptana.explorer", 0, WorkbenchNavigatorMessages.DropAdapter_problemImporting, null);
        final int currentOperation = anAdapter.getCurrentOperation();
        AppExplorerDropAdapterAssistant.mergeStatus(problems, this.validateTarget(target, anAdapter.getCurrentTransfer(), currentOperation));
        final String[] names = (String[])data;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                AppExplorerDropAdapterAssistant.this.getShell().forceActive();
                new CopyFilesAndFoldersOperation(AppExplorerDropAdapterAssistant.this.getShell()).copyOrLinkFiles(names, (IContainer)target, currentOperation);
            }
        });
        return problems;
    }

    private IStatus validateTarget(IProject target, TransferData transferType, int dropOperation) {
        if (!target.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus((String)WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        return Status.OK_STATUS;
    }

    private static void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }
}

